/* pmon.c
 * 
 * Power monitoring/automated shutdown utility
 *
 * Andrew Smallshaw
 * andrews@sdf.lonestar.org
 * 8 Dec 2002
 */

#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <signal.h>

#include "pmon.h"

int offc = 0;
int op;

void poll_power(void)
{
	write(op, "hello", 5);
	close(op);
	op = open(PORT, O_WRONLY);
	offc++;
}

int warn(char *s)
{
	FILE *msg;
	
	if (msg = popen("/usr/sbin/wall", "w")) {
		fprintf(msg, s);
		pclose(msg);
	}
}

void testloop(void)
{
	for (;;) {
		poll_power();
		
		switch(offc) {
			case 6:
				warn(WARN1);
				break;
			case 12:
				warn(WARN2);
				break;
			case 18:
				warn(WARN3);
				break;
			case 24:
				warn(WARN4);
				execl("/etc/init", "/etc/init", "0", NULL);
				/* End of process following exec */
		}
		sleep(5);
	}
}

int main(void)
{
	/* Change to root directory and check we are effective 
	 * super user to ensure shutdown works correctly should
	 * it need to be called.
	 */

	chdir("/");
	if (geteuid() != 0)	{
		fprintf(stderr, "pmon: you must be root to execute pmon.\n");
		exit(1);
	}

	/* Ensure that we can open the appropiate port, so if we 
	 * can't we can complain about it before we daemonise.
	 */
	op = open(PORT, O_WRONLY);
	if (op == 0) {
		fprintf(stderr, "pmon: unable to open %s.\n", PORT);
		exit(1);
	}
	
#ifdef DAEMONISE	
	/* Daemonise the program...
	 */
	switch (fork())	{
		case -1:
			perror("pmon: failed to start");
			exit(1);
		case 0:
			setsid();
			break;
		default:
			exit(0);	
	}
#endif /* DAEMONISE */

	/* Time to start testing the port
	 */	
	testloop();
}
